@extends('admin.template')

@section('content')




        <!-- Content Wrapper. Contains sub_category content -->
        <div class="content-wrapper" style="margin-left:10px !important;">
            <!-- Content Header (sub_category header) -->
            <section class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1>Edit sub_category</h1>
                        </div>
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                                <li class="breadcrumb-item"><a href="#">Home</a></li>
                                <li class="breadcrumb-item active">CMS</li>
                            </ol>
                        </div>
                    </div>
                </div><!-- /.container-fluid -->
            </section>









            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-md-12">
                        <div class="success">
                            @if(session()->has('success'))
                                <div class="alert alert-success">
                                    {{ session()->get('success') }}
                                </div>
                            @endif


                        </div>
                        <form action="/admin/sub_category/{{ $sub_category->id }}" method="post" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                        <div class="form-group">
                            <label for="title">Title</label>
                            <input type="title" name="title" value="{{$sub_category->title}}" class="form-control" id="title" placeholder="Enter title">
                            @error('title') {{ $message }} @enderror

                        </div>

                  <div class="form-group">
                            <label for="title">Main Category</label>
                       <select class="form-control" name="main_cat_id">

                        <option selected="selected" value="{{$sub_category->main_category->id}}">
                            {{ $sub_category->main_category->title }}
                        </option>

             <?php 
$main_category = \App\main_category::where('id','<>',$sub_category->main_category->id)->get(); 
                         ?>

                        @foreach($main_category as $row)
                           <option value="{{$row->id}}">{{ $row->title }} </option>
                        @endforeach
                       </select>
                   </div>



                        <div class="form-group">
                            <label for="img"> Image</label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" name="img" id="img" >
                                    <label class="custom-file-label" for="img">Choose file</label>
                                </div>

                                @error('img') {{ $message }} @enderror

                            </div>
                        </div>



                        <div class="card card-outline card-info">
                            <div class="card-header">
                                <h3 class="card-title">
                                    Details
                                </h3>
                                <!-- tools box -->
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool btn-sm" data-card-widget="collapse" data-toggle="tooltip"
                                            title="Collapse">
                                        <i class="fas fa-minus"></i></button>

                                </div>
                                <!-- /. tools -->
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body pad">
                                <div class="mb-3">
                <textarea class="textarea" name="details" id="details" placeholder="Place some text here"
                          style="width: 100%; height: 400px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">
                    {{ $sub_category->details }}
                </textarea>
                                    @error('details') {{ $message }} @enderror

                                </div>

                            </div>
                        </div>


                        <div class="card-footer">
                        <button class="btn btn-primary">Submit</button>
                        </div>


                        </form>


                    </div>
                    <!-- /.col-->
                </div>
                <!-- ./row -->
            </section>
            <!-- /.content -->
        </div>
        <!-- /.content-wrapper -->





@endsection
