@extends('admin.template')

@section('content')



    <div class="card">
        <div class="card-header">
            <h3 class="card-title">List of contacts</h3>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped" style="">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Message</th>
                    <th>Delete</th>
                </tr>
                </thead>
                <tbody>

@forelse($contacts as $contact)

                <tr>
                    <td> {{ $contact->id }}</td>
                    <td> {{ $contact->fullname }} </td>
                    <td> {{ $contact->email }} </td>
                    <td> {{ $contact->phone }} </td>
                    <td> {{ $contact->details }} </td>

                    <td>
                            <span class="btn btn-danger btn-sm" >
                                <form action="/admin/contact/{{ $contact->id }}" method="post">
                                    @method('DELETE')
                                    <button onclick="return confirm('Are you sure you want to delete this ?');" style="border: 0px; background:none; color: white">
                                        <i class="fas fa-trash"></i>
                                        Delete</button>
                                    @csrf
                                </form>


                            </span>

                    </td>
                </tr>

    @empty

    <tr>
       <div style="color: red; font-size: 18px; font-weight: bolder;">No Data Available</div>
    </tr>

                @endforelse










                </tbody>

            </table>
        </div>
        <!-- /.card-body -->
    </div>




@endsection
